// the evo sword, yes this ruins pvp, go away. jason-

using System;
using Server;
using Server.Mobiles;

namespace Server.Items
{
    public class SwordOfEvolution : Longsword
    {

        public override WeaponAbility PrimaryAbility { get { return WeaponAbility.ArmorIgnore; } }
        public override WeaponAbility SecondaryAbility { get { return WeaponAbility.ConcussionBlow; } }

        private int mEvolutionPoints;

        [CommandProperty(AccessLevel.GameMaster)]
        public int EvolutionPoints { get { return mEvolutionPoints; } set { mEvolutionPoints = value; } }

        public override int ArtifactRarity { get { return 500; } }

        public override int InitMinHits { get { return 255; } }
        public override int InitMaxHits { get { return 255; } }

        [Constructable]
        public SwordOfEvolution()
        {
            Name = "Sword Of Evolution";
            Hue = 0x47E;
            WeaponAttributes.UseBestSkill = 1;

            Attributes.Luck = 100;

            Attributes.WeaponDamage = 1;
            Attributes.WeaponSpeed = 10;
            Attributes.SpellChanneling = 1;
        }

        public SwordOfEvolution(Serial serial)
            : base(serial)
        {
        }

		public override bool OnEquip( Mobile from )
		{
			if ( from is PlayerMobile )
            this.BlessedFor = from;
         else if ( from is BaseCreature && ((BaseCreature)from).ControlMaster != null )
               this.BlessedFor = ((BaseCreature)from).ControlMaster;
               
         this.InvalidateProperties();
			return base.OnEquip( from );							
		}

        public override void OnHit(Mobile attacker, Mobile defender, double Damagebonus)
        {
            if ( ApplyGain( attacker, defender, this, ref mEvolutionPoints ) )
               this.Name = "Sword Of Evolution (" + mEvolutionPoints.ToString() + ")";

            base.OnHit(attacker, defender,Damagebonus);
        }
        
        private static bool GainConsume( Mobile attacker, BaseWeapon weap )
        {
            if ( weap is BaseGoldEater )
               return attacker.Backpack.ConsumeTotal( typeof( Gold ), 1500 );
            else
               return attacker.Backpack.ConsumeTotal( typeof( Xanthos.Evo.BaseEvoDust ), 30 );        
        }

        public static bool ApplyGain( Mobile attacker, Mobile defender, BaseWeapon weap, ref int mEvolutionPoints )
        {
            int expr;
            
            if ( !attacker.Player || Utility.Random( 25 ) != 1 )
               return false;
            
            if ( mEvolutionPoints != null && mEvolutionPoints < 10001 && attacker != null && defender != null && weap != null )
            {
                if ( defender is BaseCreature && ( ((BaseCreature)defender).Summoned || ((BaseCreature)defender).Controlled ) )
                   return false;
                
                if ( attacker != null && attacker.Backpack != null && !GainConsume( attacker, weap ) )
                  return false;
                
                mEvolutionPoints++;
                
                //Odmena pri max
                if ( mEvolutionPoints == 10001 )
                {
                  if ( !( weap is BaseGoldEater ) )
                  {
                     weap.MinDamage = AOS.Scale( weap.MinDamage, 130 );
                     weap.MaxDamage = AOS.Scale( weap.MaxDamage, 130 );
                     attacker.SendMessage( 15, "Tva zbran dosahla maximalni evoluce, jeji zakladni damage bylo zvyseno o 30%." );
                  }
                  
                  if ( weap is SpectralScimitarOfEvolution )
                  {
                     Item ps = new PowerScroll( SkillName.Tactics, 130.0 );
                     ps.BlessedFor = attacker;
                     ps.LootType = LootType.Regular;
                     attacker.AddToBackpack( ps );
                     attacker.SendMessage( 15, "Ziskavas odmenu za maximalní uroven spectral scimitar of evolution." );
                  }
                }

                if ((mEvolutionPoints / 100) > 0)
                {
                    expr = mEvolutionPoints / 100;

                    weap.WeaponAttributes.HitHarm = expr;
                    weap.WeaponAttributes.HitMagicArrow = expr;
                    
//                     if ( weap is BaseGoldEater )
//                     {
                        expr = Math.Max( 1, expr / 2 );
                        
                        weap.WeaponAttributes.HitLeechHits = expr;
                        weap.WeaponAttributes.HitLeechStam = expr;
                        weap.WeaponAttributes.HitLeechMana = expr;
                        weap.Attributes.AttackChance = Math.Max( 1, expr / 2 );
//                     }
                }

                if ((mEvolutionPoints / 200) > 0)
                {
                    expr = mEvolutionPoints / 100;

                    weap.WeaponAttributes.HitLightning = expr;
                    weap.WeaponAttributes.HitFireball = expr;
                    weap.Attributes.WeaponDamage = expr;
                    
//                     if ( weap is SlayerLongbowOfEvolution || weap is SlayerWakizashiOfEvolution || weap is BaseGoldEater )
//                     {
                        expr = Math.Max( 1, expr / 10 );
                        
                        weap.SkillBonuses.SetValues( 0, weap.Skill, expr );
                        weap.SkillBonuses.SetValues( 1, SkillName.Tactics, expr );
//                     }
                }

                if ((25 + (mEvolutionPoints / 200)) > 0)
                  weap.Attributes.WeaponSpeed = (25 + (mEvolutionPoints / 200));

                if ((mEvolutionPoints / 2000) > 0)
                {
                    expr = mEvolutionPoints / 2000;

                    weap.Attributes.CastRecovery = expr;
                    weap.Attributes.CastSpeed = expr;
                }
                weap.InvalidateProperties();
                return true;
            }
            
            return false;
        }

        public override void Serialize(GenericWriter writer)
        {
            base.Serialize(writer);

            writer.Write((int)2);
            writer.Write(mEvolutionPoints);
        }

        public override void Deserialize(GenericReader reader)
        {
            base.Deserialize(reader);

            int version = reader.ReadInt();
            mEvolutionPoints = reader.ReadInt();
            
            if ( version == 0 && mEvolutionPoints == 10001 )
               mEvolutionPoints = 10000;
               
            if ( version == 1 && mEvolutionPoints == 10001 )
            {
               this.MinDamage = AOS.Scale( this.MinDamage, 130 );
               this.MaxDamage = AOS.Scale( this.MaxDamage, 130 );
            }
        }
    }
}